/*!
 * @file        usbh_msc.h
 *
 * @brief       USB MSC core function head file
 *
 * @version     V1.0.1
 *
 * @date        2022-05-25
 *
 * @attention
 *
 *  Copyright (C) 2021-2022 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be usefull and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */
#ifndef __USBH_MSC_H_
#define __USBH_MSC_H_

#include "usbh_core.h"
#include "ff.h"
#include "diskio.h"

extern FATFS *fs[FF_VOLUMES];
extern char fileScanPath[255];

/** function declaration*/
void USBH_MSC_Init(void);
uint8_t USBH_DeviceStatus(void);
uint8_t USB_DiskRead(uint8_t* buffer, uint32_t sector, uint32_t cnt);
uint8_t USB_DiskWrite(uint8_t* buffer, uint32_t sector, uint32_t cnt);

/** function declaration*/
FRESULT FATFS_ScanFiles(char* path);
void FATFS_WriteReadFile(FIL *file);

#endif
